<?php
require_once("../Checksum/PaytmChecksum.php");

$paytmParams = array();
$paytmParams["body"] = array(
    "requestType"   => "Payment",
    "mid"           => "QmWuZe78987086625194",
    "websiteName"   => "gomatkapro",
    "orderId"       => "ORDERID_98765",
    "callbackUrl"   => "https://gomatkapro.co",
    "txnAmount"     => array(
        "value"     => "1.00",
        "currency"  => "INR",
    ),
    "userInfo"      => array(
        "custId"    => "CUST_001",
    ),
);

/*
* Generate checksum by parameters we have in body
* Find your Merchant Key in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys 
*/
$checksum = PaytmChecksum::generateSignature(json_encode($paytmParams["body"], JSON_UNESCAPED_SLASHES), "dE_2yWgWAdVLY!1Z");
$paytmParams["head"] = array(
    "signature"    => $checksum
);
$post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);

/* for Staging */
$url = "https://securegw-stage.paytm.in/theia/api/v1/initiateTransaction?mid=QmWuZe78987086625194&orderId=ORDERID_98765";

/* for Production */
// $url = "https://securegw.paytm.in/theia/api/v1/initiateTransaction?mid=YOUR_MID_HERE&orderId=ORDERID_98765";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json")); 
$response = curl_exec($ch);
print_r($response);



?>